/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.esl.energy;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.antarcticgardens.esl.ESL;
import org.antarcticgardens.esl.transaction.TransactionContext;
import org.antarcticgardens.esl.util.ItemHolder;
import org.jetbrains.annotations.Nullable;

public interface EnergyStorage {
    public long insert(long var1, TransactionContext var3);

    public long extract(long var1, TransactionContext var3);

    public long getStoredEnergy();

    public long getCapacity();

    default public boolean supportsExtraction() {
        return true;
    }

    default public boolean supportsInsertion() {
        return true;
    }

    public static EnergyStorage findForBlock(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return ESL.getInstance().getBlockEnergyStorageManager().find(world, pos, direction);
    }

    public static <T extends class_2586> void registerForBlockEntity(BiFunction<T, class_2350, @Nullable EnergyStorage> provider, class_2591<T> blockEntityType) {
        ESL.getInstance().getBlockEnergyStorageManager().registerForBlockEntity(provider, blockEntityType);
    }

    public static EnergyStorage findForItem(ItemHolder holder) {
        return ESL.getInstance().getItemEnergyStorageManager().find(holder);
    }

    public static void registerForItem(Function<ItemHolder, EnergyStorage> provider, class_1935 item) {
        ESL.getInstance().getItemEnergyStorageManager().register(provider, item);
    }
}

